<?php 
    include_once('header.php'); 
    include_once('inc.function.php');
    
    session_unset();
    session_destroy();
    session_write_close();
    setcookie(session_name(),'',0,'/');
    session_regenerate_id(true);
?>

    <!-- Begin page content -->
    <div class="container">
      <div class="page-header">
        <h1><img src='img/logo.jpg'/>&nbsp ONLINE BOOKING</h1>
      </div>
      <!-- CONTENT STARTS HERE -->
      <div class="stepwizard">
          <div class="stepwizard-row setup-panel">
              <div class="stepwizard-step">
                  <a href="#step-1" type="button" class="btn btn-warning btn-circle">1</a>
                  <p>Venue Search</p>
              </div>
              <div class="stepwizard-step">
                  <a href="#step-2" type="button" class="btn btn-danger btn-circle" disabled="disabled">2</a>
                  <p>Venue Booking</p>
              </div>
              <div class="stepwizard-step">
                  <a href="#step-3" type="button" class="btn btn-danger btn-circle" disabled="disabled">3</a>
                  <p>Event Detail</p>
              </div>
              <div class="stepwizard-step">
                  <a href="#step-4" type="button" class="btn btn-danger btn-circle" disabled="disabled">4</a>
                  <p>Contact Info</p>
              </div>
              <div class="stepwizard-step">
                  <a href="#step-5" type="button" class="btn btn-danger btn-circle" disabled="disabled">5</a>
                  <p>Mailing Address</p>
              </div>
              <div class="stepwizard-step">
                  <a href="#step-6" type="button" class="btn btn-danger btn-circle" disabled="disabled">6</a>
                  <p>Booking Submission</p>
              </div>
          </div>
      </div>

      <div class="progress">
        <div class="progress-bar progress-bar-striped progress-bar-success active" role="progressbar"
        aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" style="width:15%">
          20%
        </div>
      </div>

      <br>
      <?php if(!empty($_SESSION['MESSAGE'])) { echo $_SESSION['MESSAGE'].'<br>';  unset($_SESSION['MESSAGE']); } ?>

       <form method="post" action="booking_pre.php">

        <div class="row setup-content" id="step-1">
            <div class="col-xs-12">
                <div class="col-md-12">
                    <h3> Step 1: Venue Search</h3>
                    <p>

                    <h4>Select Date:</h4>
                    <div class="well">


                         <fieldset>
                          <div class="control-group">
                            <div class="controls">
                             <div class="input-prepend input-group">
                               <span class="add-on input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span><input type="text" style="width: 200px" name="reservation" id="reservation" class="form-control" value="<?php echo date("d-m-Y", strtotime("+1 day")).' - '.date("d-m-Y", strtotime("+2 day")); ?>" /> 
                             </div>
                            </div>
                          </div>
                         </fieldset>
                         <p class="text-danger"><small>* required. (dd-mm-yyyy)</small></p>
                               <script type="text/javascript">
                               $(document).ready(function() {
                                        $('#reservation').daterangepicker(
                                                    { 
                                                        format: 'DD-MM-YYYY',
                                                        minDate: '<?php echo date("d-m-Y"); ?>',
                                                        startDate: '<?php echo date("d-m-Y", strtotime("+1 day")); ?>',
                                                        endDate: '<?php echo date("d-m-Y", strtotime("+2 day")); ?>'
                                                    }
                                        );
                                        $('#reservation').on('apply.daterangepicker', function(ev, picker) {
                                          console.log(picker.startDate.format('DD-MM-YYYY'));
                                          console.log(picker.endDate.format('DD-MM-YYYY'));
                                        });
                               });
                               </script>

                    </div>


                    <div class="form-group">
                        <h4>No of Pax:</h4>
                        <div class="well">
                          <fieldset>
                          <div class="control-group">
                            <div class="controls">
                                <div class="input-prepend input-group">
                                    <span class="add-on input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                                    <input type="text" name="PAX" id="PAX" required="required" class="form-control" placeholder="Enter Pax In Number" maxlength="5" value="<?php echo $_SESSION['PAX']; ?>" />
                                </div>
                            </div>
                          </div>
                         </fieldset>
                         <p class="text-danger"><small>* required.</small></p>
                    </div>
                    <input type="submit" class="btn btn-primary btn-lg pull-right" value="Next" />
                </div>
            </div>
        </div>

       </form>

      <!-- CONTENT ENDS HERE -->
    </div>

<?php include_once('footer.php'); ?>
